

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL auto_increment,
  `comment_post_ID` bigint(20) unsigned NOT NULL default '0',
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL default '',
  `comment_author_url` varchar(200) NOT NULL default '',
  `comment_author_IP` varchar(100) NOT NULL default '',
  `comment_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL default '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL default '0',
  `comment_approved` varchar(20) NOT NULL default '1',
  `comment_agent` varchar(255) NOT NULL default '',
  `comment_type` varchar(20) NOT NULL default '',
  `comment_parent` bigint(20) unsigned NOT NULL default '0',
  `user_id` bigint(20) unsigned NOT NULL default '0',
  PRIMARY KEY  (`comment_ID`),
  KEY `comment_approved` (`comment_approved`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO wp_comments VALUES("1","1","Mr WordPress","","http://wordpress.org/","","2009-07-13 20:40:30","2009-07-14 00:40:30","Hi, this is a comment.<br />To delete a comment, just log in and view the post&#039;s comments. There you will have the option to edit or delete them.","0","1","","","0","0");





CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL auto_increment,
  `link_url` varchar(255) NOT NULL default '',
  `link_name` varchar(255) NOT NULL default '',
  `link_image` varchar(255) NOT NULL default '',
  `link_target` varchar(25) NOT NULL default '',
  `link_description` varchar(255) NOT NULL default '',
  `link_visible` varchar(20) NOT NULL default 'Y',
  `link_owner` bigint(20) unsigned NOT NULL default '1',
  `link_rating` int(11) NOT NULL default '0',
  `link_updated` datetime NOT NULL default '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL default '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL default '',
  PRIMARY KEY  (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO wp_links VALUES("1","http://codex.wordpress.org/","Documentation","","","","Y","1","0","0000-00-00 00:00:00","","","");
INSERT INTO wp_links VALUES("2","http://wordpress.org/development/","Development Blog","","","","Y","1","0","0000-00-00 00:00:00","","","http://wordpress.org/development/feed/");
INSERT INTO wp_links VALUES("3","http://wordpress.org/extend/ideas/","Suggest Ideas","","","","Y","1","0","0000-00-00 00:00:00","","","");
INSERT INTO wp_links VALUES("4","http://wordpress.org/support/","Support Forum","","","","Y","1","0","0000-00-00 00:00:00","","","");
INSERT INTO wp_links VALUES("5","http://wordpress.org/extend/plugins/","Plugins","","","","Y","1","0","0000-00-00 00:00:00","","","");
INSERT INTO wp_links VALUES("6","http://wordpress.org/extend/themes/","Themes","","","","Y","1","0","0000-00-00 00:00:00","","","");
INSERT INTO wp_links VALUES("7","http://planet.wordpress.org/","WordPress Planet","","","","Y","1","0","0000-00-00 00:00:00","","","");





CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL auto_increment,
  `blog_id` int(11) NOT NULL default '0',
  `option_name` varchar(64) NOT NULL default '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL default 'yes',
  PRIMARY KEY  (`option_id`,`blog_id`,`option_name`),
  KEY `option_name` (`option_name`)
) ENGINE=InnoDB AUTO_INCREMENT=115 DEFAULT CHARSET=utf8;

INSERT INTO wp_options VALUES("1","0","_transient_random_seed","518b35938c4d54e00822f6bc1d4de5c2","yes");
INSERT INTO wp_options VALUES("2","0","siteurl","http://wpgeneral.com/wpusers/test/13","yes");
INSERT INTO wp_options VALUES("3","0","blogname","blog 19","yes");
INSERT INTO wp_options VALUES("4","0","blogdescription","taggy 19","yes");
INSERT INTO wp_options VALUES("5","0","users_can_register","0","yes");
INSERT INTO wp_options VALUES("6","0","admin_email","what@what.com","yes");
INSERT INTO wp_options VALUES("7","0","start_of_week","1","yes");
INSERT INTO wp_options VALUES("8","0","use_balanceTags","0","yes");
INSERT INTO wp_options VALUES("9","0","use_smilies","1","yes");
INSERT INTO wp_options VALUES("10","0","require_name_email","1","yes");
INSERT INTO wp_options VALUES("11","0","comments_notify","1","yes");
INSERT INTO wp_options VALUES("12","0","posts_per_rss","10","yes");
INSERT INTO wp_options VALUES("13","0","rss_excerpt_length","50","yes");
INSERT INTO wp_options VALUES("14","0","rss_use_excerpt","0","yes");
INSERT INTO wp_options VALUES("15","0","mailserver_url","mail.example.com","yes");
INSERT INTO wp_options VALUES("16","0","mailserver_login","login@example.com","yes");
INSERT INTO wp_options VALUES("17","0","mailserver_pass","password","yes");
INSERT INTO wp_options VALUES("18","0","mailserver_port","110","yes");
INSERT INTO wp_options VALUES("19","0","default_category","1","yes");
INSERT INTO wp_options VALUES("20","0","default_comment_status","open","yes");
INSERT INTO wp_options VALUES("21","0","default_ping_status","open","yes");
INSERT INTO wp_options VALUES("22","0","default_pingback_flag","0","yes");
INSERT INTO wp_options VALUES("23","0","default_post_edit_rows","10","yes");
INSERT INTO wp_options VALUES("24","0","posts_per_page","10","yes");
INSERT INTO wp_options VALUES("25","0","date_format","F j, Y","yes");
INSERT INTO wp_options VALUES("26","0","time_format","g:i a","yes");
INSERT INTO wp_options VALUES("27","0","links_updated_date_format","F j, Y g:i a","yes");
INSERT INTO wp_options VALUES("28","0","links_recently_updated_prepend","<em>","yes");
INSERT INTO wp_options VALUES("29","0","links_recently_updated_append","</em>","yes");
INSERT INTO wp_options VALUES("30","0","links_recently_updated_time","120","yes");
INSERT INTO wp_options VALUES("31","0","comment_moderation","0","yes");
INSERT INTO wp_options VALUES("32","0","moderation_notify","1","yes");
INSERT INTO wp_options VALUES("33","0","permalink_structure","","yes");
INSERT INTO wp_options VALUES("34","0","gzipcompression","0","yes");
INSERT INTO wp_options VALUES("35","0","hack_file","0","yes");
INSERT INTO wp_options VALUES("36","0","blog_charset","UTF-8","yes");
INSERT INTO wp_options VALUES("37","0","moderation_keys","","no");
INSERT INTO wp_options VALUES("38","0","active_plugins","a:0:{}","yes");
INSERT INTO wp_options VALUES("39","0","home","http://wpgeneral.com/wpusers/test/13","yes");
INSERT INTO wp_options VALUES("40","0","category_base","","yes");
INSERT INTO wp_options VALUES("41","0","ping_sites","http://rpc.pingomatic.com/","yes");
INSERT INTO wp_options VALUES("42","0","advanced_edit","0","yes");
INSERT INTO wp_options VALUES("43","0","comment_max_links","2","yes");
INSERT INTO wp_options VALUES("44","0","gmt_offset","-4","yes");
INSERT INTO wp_options VALUES("45","0","default_email_category","1","yes");
INSERT INTO wp_options VALUES("46","0","recently_edited","","no");
INSERT INTO wp_options VALUES("47","0","use_linksupdate","0","yes");
INSERT INTO wp_options VALUES("48","0","template","default","yes");
INSERT INTO wp_options VALUES("49","0","stylesheet","default","yes");
INSERT INTO wp_options VALUES("50","0","comment_whitelist","1","yes");
INSERT INTO wp_options VALUES("51","0","blacklist_keys","","no");
INSERT INTO wp_options VALUES("52","0","comment_registration","0","yes");
INSERT INTO wp_options VALUES("53","0","rss_language","en","yes");
INSERT INTO wp_options VALUES("54","0","html_type","text/html","yes");
INSERT INTO wp_options VALUES("55","0","use_trackback","0","yes");
INSERT INTO wp_options VALUES("56","0","default_role","subscriber","yes");
INSERT INTO wp_options VALUES("57","0","db_version","11548","yes");
INSERT INTO wp_options VALUES("58","0","uploads_use_yearmonth_folders","1","yes");
INSERT INTO wp_options VALUES("59","0","upload_path","C:\\APPLICATIONS\\wamp\\www\\testWP/wp-content/uploads","yes");
INSERT INTO wp_options VALUES("60","0","secret","e%KX!t9wY@krzooab&$d35gblCB%!Y35tK@^!LCZ2KmuZqgAor8kET0CS1KVTjy5","yes");
INSERT INTO wp_options VALUES("61","0","blog_public","0","yes");
INSERT INTO wp_options VALUES("62","0","default_link_category","2","yes");
INSERT INTO wp_options VALUES("63","0","show_on_front","posts","yes");
INSERT INTO wp_options VALUES("64","0","tag_base","","yes");
INSERT INTO wp_options VALUES("65","0","show_avatars","1","yes");
INSERT INTO wp_options VALUES("66","0","avatar_rating","G","yes");
INSERT INTO wp_options VALUES("67","0","upload_url_path","","yes");
INSERT INTO wp_options VALUES("68","0","thumbnail_size_w","150","yes");
INSERT INTO wp_options VALUES("69","0","thumbnail_size_h","150","yes");
INSERT INTO wp_options VALUES("70","0","thumbnail_crop","1","yes");
INSERT INTO wp_options VALUES("71","0","medium_size_w","300","yes");
INSERT INTO wp_options VALUES("72","0","medium_size_h","300","yes");
INSERT INTO wp_options VALUES("73","0","avatar_default","mystery","yes");
INSERT INTO wp_options VALUES("74","0","enable_app","0","yes");
INSERT INTO wp_options VALUES("75","0","enable_xmlrpc","0","yes");
INSERT INTO wp_options VALUES("76","0","large_size_w","1024","yes");
INSERT INTO wp_options VALUES("77","0","large_size_h","1024","yes");
INSERT INTO wp_options VALUES("78","0","image_default_link_type","file","yes");
INSERT INTO wp_options VALUES("79","0","image_default_size","","yes");
INSERT INTO wp_options VALUES("80","0","image_default_align","","yes");
INSERT INTO wp_options VALUES("81","0","close_comments_for_old_posts","0","yes");
INSERT INTO wp_options VALUES("82","0","close_comments_days_old","14","yes");
INSERT INTO wp_options VALUES("83","0","thread_comments","0","yes");
INSERT INTO wp_options VALUES("84","0","thread_comments_depth","5","yes");
INSERT INTO wp_options VALUES("85","0","page_comments","1","yes");
INSERT INTO wp_options VALUES("86","0","comments_per_page","50","yes");
INSERT INTO wp_options VALUES("87","0","default_comments_page","newest","yes");
INSERT INTO wp_options VALUES("88","0","comment_order","asc","yes");
INSERT INTO wp_options VALUES("89","0","sticky_posts","a:0:{}","yes");
INSERT INTO wp_options VALUES("90","0","widget_categories","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("91","0","widget_text","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("92","0","widget_rss","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("93","0","timezone_string","","yes");
INSERT INTO wp_options VALUES("94","0","wp_user_roles","a:5:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:54:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}}","yes");
INSERT INTO wp_options VALUES("95","0","_transient_rewrite_rules","","yes");
INSERT INTO wp_options VALUES("96","0","cron","a:2:{i:1264120936;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}s:7:\"version\";i:2;}","yes");
INSERT INTO wp_options VALUES("97","0","_transient_doing_cron","1264083738","yes");
INSERT INTO wp_options VALUES("98","0","_transient_update_core","O:8:\"stdClass\":3:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":5:{s:8:\"response\";s:7:\"upgrade\";s:3:\"url\";s:30:\"http://wordpress.org/download/\";s:7:\"package\";s:40:\"http://wordpress.org/wordpress-2.9.1.zip\";s:7:\"current\";s:5:\"2.9.1\";s:6:\"locale\";s:5:\"en_US\";}}s:12:\"last_checked\";i:1264083739;s:15:\"version_checked\";s:5:\"2.8.4\";}","yes");
INSERT INTO wp_options VALUES("99","0","_transient_update_plugins","O:8:\"stdClass\":3:{s:12:\"last_checked\";i:1264083739;s:7:\"checked\";a:2:{s:19:\"akismet/akismet.php\";s:5:\"2.2.6\";s:9:\"hello.php\";s:5:\"1.5.1\";}s:8:\"response\";a:1:{s:19:\"akismet/akismet.php\";O:8:\"stdClass\":5:{s:2:\"id\";s:2:\"15\";s:4:\"slug\";s:7:\"akismet\";s:11:\"new_version\";s:5:\"2.2.7\";s:3:\"url\";s:44:\"http://wordpress.org/extend/plugins/akismet/\";s:7:\"package\";s:49:\"http://downloads.wordpress.org/plugin/akismet.zip\";}}}","yes");
INSERT INTO wp_options VALUES("100","0","_transient_update_themes","O:8:\"stdClass\":1:{s:12:\"last_checked\";i:1264083739;}","yes");
INSERT INTO wp_options VALUES("101","0","category_children","a:0:{}","yes");
INSERT INTO wp_options VALUES("102","0","widget_pages","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("103","0","widget_calendar","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("104","0","widget_archives","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("105","0","widget_links","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("106","0","widget_meta","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("107","0","widget_search","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("108","0","widget_recent-posts","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("109","0","widget_recent-comments","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("110","0","widget_tag_cloud","a:2:{i:2;a:0:{}s:12:\"_multiwidget\";i:1;}","yes");
INSERT INTO wp_options VALUES("111","0","auth_salt","&A7dF2DLWtlvTvynMi5bkK5$UqWm3V57J0B4XjX!xbt#zza$0vjB6qOv3tECWwO6","yes");
INSERT INTO wp_options VALUES("112","0","logged_in_salt","wBzwWU4@!5kv50vSgCzDJRJPp1(XR$nQXPCy^^o3MH99@tR7(SRJBVBw2&Y2#ngK","yes");
INSERT INTO wp_options VALUES("113","0","nonce_salt","PJQk5jPwbqffHW*dnoe&z0I5VDKghd(1qyFkH1*T3Fbtn&bocKs84wD0aQx73TWj","yes");
INSERT INTO wp_options VALUES("114","0","can_compress_scripts","1","yes");





CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL auto_increment,
  `post_id` bigint(20) unsigned NOT NULL default '0',
  `meta_key` varchar(255) default NULL,
  `meta_value` longtext,
  PRIMARY KEY  (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;






CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `post_author` bigint(20) unsigned NOT NULL default '0',
  `post_date` datetime NOT NULL default '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL default '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL default 'publish',
  `comment_status` varchar(20) NOT NULL default 'open',
  `ping_status` varchar(20) NOT NULL default 'open',
  `post_password` varchar(20) NOT NULL default '',
  `post_name` varchar(200) NOT NULL default '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL default '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL default '0000-00-00 00:00:00',
  `post_content_filtered` text NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL default '0',
  `guid` varchar(255) NOT NULL default '',
  `menu_order` int(11) NOT NULL default '0',
  `post_type` varchar(20) NOT NULL default 'post',
  `post_mime_type` varchar(100) NOT NULL default '',
  `comment_count` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`ID`),
  KEY `post_name` (`post_name`),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO wp_posts VALUES("1","1","2009-07-13 20:40:30","2009-07-14 00:40:30","Welcome to WordPress. This is your first post. Edit or delete it, then start blogging!","Hello world!","","publish","open","open","","hello-world","","","2009-07-13 20:40:30","2009-07-14 00:40:30","","0","http://localhost/testWP/?p=1","0","post","","1");
INSERT INTO wp_posts VALUES("2","1","2009-07-13 20:40:30","2009-07-14 00:40:30","This is an example of a WordPress page, you could edit this to put information about yourself or your site so readers know where you are coming from. You can create as many pages like this one or sub-pages as you like and manage all of your content inside of WordPress.","About","","publish","open","open","","about","","","2009-07-13 20:40:30","2009-07-14 00:40:30","","0","http://localhost/testWP/?page_id=2","0","page","","0");





CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL default '0',
  `term_taxonomy_id` bigint(20) unsigned NOT NULL default '0',
  `term_order` int(11) NOT NULL default '0',
  PRIMARY KEY  (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

INSERT INTO wp_term_relationships VALUES("1","1","0");
INSERT INTO wp_term_relationships VALUES("1","2","0");
INSERT INTO wp_term_relationships VALUES("2","2","0");
INSERT INTO wp_term_relationships VALUES("3","2","0");
INSERT INTO wp_term_relationships VALUES("4","2","0");
INSERT INTO wp_term_relationships VALUES("5","2","0");
INSERT INTO wp_term_relationships VALUES("6","2","0");
INSERT INTO wp_term_relationships VALUES("7","2","0");





CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL auto_increment,
  `term_id` bigint(20) unsigned NOT NULL default '0',
  `taxonomy` varchar(32) NOT NULL default '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL default '0',
  `count` bigint(20) NOT NULL default '0',
  PRIMARY KEY  (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO wp_term_taxonomy VALUES("1","1","category","","0","1");
INSERT INTO wp_term_taxonomy VALUES("2","2","link_category","","0","7");





CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL auto_increment,
  `name` varchar(200) NOT NULL default '',
  `slug` varchar(200) NOT NULL default '',
  `term_group` bigint(10) NOT NULL default '0',
  PRIMARY KEY  (`term_id`),
  UNIQUE KEY `slug` (`slug`),
  KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;

INSERT INTO wp_terms VALUES("1","Uncategorized","uncategorized","0");
INSERT INTO wp_terms VALUES("2","Blogroll","blogroll","0");





CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL auto_increment,
  `user_id` bigint(20) unsigned NOT NULL default '0',
  `meta_key` varchar(255) default NULL,
  `meta_value` longtext,
  PRIMARY KEY  (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;

INSERT INTO wp_usermeta VALUES("1","1","nickname","admin");
INSERT INTO wp_usermeta VALUES("2","1","rich_editing","true");
INSERT INTO wp_usermeta VALUES("3","1","comment_shortcuts","false");
INSERT INTO wp_usermeta VALUES("4","1","admin_color","fresh");
INSERT INTO wp_usermeta VALUES("5","1","wp_capabilities","a:1:{s:13:\"administrator\";b:1;}");
INSERT INTO wp_usermeta VALUES("6","1","default_password_nag","1");
INSERT INTO wp_usermeta VALUES("7","1","wp_user_level","10");





CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL auto_increment,
  `user_login` varchar(60) NOT NULL default '',
  `user_pass` varchar(64) NOT NULL default '',
  `user_nicename` varchar(50) NOT NULL default '',
  `user_email` varchar(100) NOT NULL default '',
  `user_url` varchar(100) NOT NULL default '',
  `user_registered` datetime NOT NULL default '0000-00-00 00:00:00',
  `user_activation_key` varchar(60) NOT NULL default '',
  `user_status` int(11) NOT NULL default '0',
  `display_name` varchar(250) NOT NULL default '',
  PRIMARY KEY  (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO wp_users VALUES("1","admin","$P$B9kiw8O8BponQPDf3S4xqluvgPGAal.","admin","test","","2009-07-14 00:40:29","","0","admin");



